;
;	Z80 Numerical Opcodes
;	07/28/96
;
NN	EQU	1234H
N	EQU	5
;
	ORG	0
;
START:	NOP			; 00
	LD	BC,NN		; 01
	LD	(BC),A		; 02
	INC	BC		; 03
	INC	B		; 04
	DEC	B		; 05
	LD	B,N		; 06
	RLCA			; 07
	EX	AF,AF'		; 08
	ADD	HL,BC		; 09
	LD	A,(BC)		; 0a
	DEC	BC		; 0b
	INC	C		; 0c
	DEC	C		; 0d
	LD	C,N		; 0e
LOC1:	RRCA			; 0f
	DJNZ	START		; 10
	LD	DE,NN		; 11
	LD	(DE),A		; 12
	INC	DE		; 13
	INC	D		; 14
	DEC	D		; 15
	LD	D,N		; 16
	RLA			; 17
	JR	LOC1		; 18
;
	ADD	HL,DE		; 19
	LD	A,(DE)		; 1a
	DEC	DE		; 1b
	INC	E		; 1c
	DEC	E		; 1d
	LD	E,N		; 1e
LOC2:	RRA			; 1f
	JR	NZ,LOC2		; 20
	LD	HL,NN		; 21
	LD	(NN),HL		; 22
	INC	HL		; 23
	INC	H		; 24
	DEC	H		; 25
	LD	H,N		; 26
	DAA			; 27
	JR	Z,LOC2		; 28
	ADD	HL,HL		; 29
	LD	HL,(NN)		; 2a
	DEC	HL		; 2b
	INC	L		; 2c
	DEC	L		; 2d
	LD	L,N		; 2e
LOC3:	CPL			; 2f
	JR	NC,LOC3		; 30
	LD	SP,NN		; 31
	LD	(NN),A		; 32
	INC	SP		; 33
	INC	(HL)		; 34
	DEC	(HL)		; 35
	LD	(HL),N		; 36
	SCF			; 37
	JR	C,LOC3		; 38
	ADD	HL,SP		; 39
	LD	A,(NN)		; 3a
	DEC	SP		; 3b
	INC	A		; 3c
	DEC	A		; 3d
	LD	A,N		; 3e
	CCF			; 3f
	LD	B,B		; 40
	LD	B,C		; 41
	LD	B,D		; 42
	LD	B,E		; 43
	LD	B,H		; 44
	LD	B,L		; 45
	LD	B,(HL)		; 46
	LD	B,A		; 47
	LD	C,B		; 48
	LD	C,C		; 49
	LD	C,D		; 4a
	LD	C,E		; 4b
	LD	C,H		; 4c
	LD	C,L		; 4d
	LD	C,(HL)		; 4e
	LD	C,A		; 4f
	LD	D,B		; 50
	LD	D,C		; 51
	LD	D,D		; 52
	LD	D,E		; 53
	LD	D,H		; 54
	LD	D,L		; 55
	LD	D,(HL)		; 56
	LD	D,A		; 57
	LD	E,B		; 58
	LD	E,C		; 59
	LD	E,D		; 5a
	LD	E,E		; 5b
	LD	E,H		; 5c
	LD	E,L		; 5d
	LD	E,(HL)		; 5e
	LD	E,A		; 5f
	LD	H,B		; 60
	LD	H,C		; 61
	LD	H,D		; 62
	LD	H,E		; 63
	LD	H,H		; 64
	LD	H,L		; 65
	LD	H,(HL)		; 66
	LD	H,A		; 67
	LD	L,B		; 68
	LD	L,C		; 69
	LD	L,D		; 6a
	LD	L,E		; 6b
	LD	L,H		; 6c
	LD	L,L		; 6d
	LD	L,(HL)		; 6e
	LD	L,A		; 6f
	LD	(HL),B		; 70
	LD	(HL),C		; 71
	LD	(HL),D		; 72
	LD	(HL),E		; 73
	LD	(HL),H		; 74
	LD	(HL),L		; 75
	HALT			; 76
;
	LD	(HL),A		; 77
	LD	A,B		; 78
	LD	A,C		; 79
	LD	A,D		; 7a
	LD	A,E		; 7b
	LD	A,H		; 7c
	LD	A,L		; 7d
	LD	A,(HL)		; 7e
	LD	A,A		; 7f
	ADD	A,B		; 80
	ADD	A,C		; 81
	ADD	A,D		; 82
	ADD	A,E		; 83
	ADD	A,H		; 84
	ADD	A,L		; 85
	ADD	A,(HL)		; 86
	ADD	A,A		; 87
	ADC	A,B		; 88
	ADC	A,C		; 89
	ADC	A,D		; 8a
	ADC	A,E		; 8b
	ADC	A,H		; 8c
	ADC	A,L		; 8d
	ADC	A,(HL)		; 8e
	ADC	A,A		; 8f
	SUB	B		; 90
	SUB	C		; 91
	SUB	D		; 92
	SUB	E		; 93
	SUB	H		; 94
	SUB	L		; 95
	SUB	(HL)		; 96
	SUB	A		; 97
	SBC	A,B		; 98
	SBC	A,C		; 99
	SBC	A,D		; 9a
	SBC	A,E		; 9b
	SBC	A,H		; 9c
	SBC	A,L		; 9d
	SBC	A,(HL)		; 9e
	SBC	A,A		; 9f
	AND	B		; a0
	AND	C		; a1
	AND	D		; a2
	AND	E		; a3
	AND	H		; a4
	AND	L		; a5
	AND	(HL)		; a6
	AND	A		; a7
	XOR	B		; a8
	XOR	C		; a9
	XOR	D		; aa
	XOR	E		; ab
	XOR	H		; ac
	XOR	L		; ad
	XOR	(HL)		; ae
	XOR	A		; af
	OR	B		; b0
	OR	C		; b1
	OR	D		; b2
	OR	E		; b3
	OR	H		; b4
	OR	L		; b5
	OR	(HL)		; b6
	OR	A		; b7
	CP	B		; b8
	CP	C		; b9
	CP	D		; ba
	CP	E		; bb
	CP	H		; bc
	CP	L		; bd
	CP	(HL)		; be
	CP	A		; bf
	RET	NZ		; c0
	POP	BC		; c1
	JP	NZ,NN		; c2
	JP	NN		; c3
;
	CALL	NZ,NN		; c4
	PUSH	BC		; c5
	ADD	A,N		; c6
	RST	0		; c7
	RET	Z		; c8
	RET			; c9
;
	JP	Z,NN		; ca ; cb are extended codes
	CALL	Z,NN		; cc
	CALL	NN		; cd
	ADC	A,N		; ce
	RST	8		; cf
	RET	NC		; d0
	POP	DE		; d1
	JP	NC,NN		; d2
	OUT	(N),A		; d3
	CALL	NC,NN		; d4
	PUSH	DE		; d5
	SUB	N		; d6
	RST	10H		; d7
	RET	C		; d8
	EXX			; d9
	JP	C,NN		; da
	IN	A,(N)		; db
	CALL	C,NN		; dc ; dd are IX index codes
	SBC	A,N		; de
	RST	18H		; df
	RET	PO		; e0
	POP	HL		; e1
	JP	PO,NN		; e2
	EX	(SP),HL		; e3
	CALL	PO,NN		; e4
	PUSH	HL		; e5
	AND	N		; e6
	RST	20H		; e7
	RET	PE		; e8
	JP	(HL)		; e9
;
	JP	PE,NN		; ea
	EX	DE,HL		; eb
	CALL	PE,NN		; ec ; ed are extended codes
	XOR	N		; ee
	RST	28H		; ef
	RET	P		; f0
	POP	AF		; f1
	JP	P,NN		; f2
	DI			; f3
	CALL	P,NN		; f4
	PUSH	AF		; f5
	OR	N		; f6
	RST	30H		; f7
	RET	M		; f8
	LD	SP,HL		; f9
	JP	M,NN		; fa
	EI			; fb
	CALL	M,NN		; fc ; fd are IY index codes
	CP	N		; fe
	RST	38H		; ff
	RLC	B		; cb 00 ;  cb extended codes
	RLC	C		; cb 01
	RLC	D		; cb 02
	RLC	E		; cb 03
	RLC	H		; cb 04
	RLC	L		; cb 05
	RLC	(HL)		; cb 06
	RLC	A		; cb 07
	RRC	B		; cb 08
	RRC	C		; cb 09
	RRC	D		; cb 0a
	RRC	E		; cb 0b
	RRC	H		; cb 0c
	RRC	L		; cb 0d
	RRC	(HL)		; cb 0e
	RRC	A		; cb 0f
	RL	B		; cb 10
	RL	C		; cb 11
	RL	D		; cb 12
	RL	E		; cb 13
	RL	H		; cb 14
	RL	L		; cb 15
	RL	(HL)		; cb 16
	RL	A		; cb 17
	RR	B		; cb 18
	RR	C		; cb 19
	RR	D		; cb 1a
	RR	E		; cb 1b
	RR	H		; cb 1c
	RR	L		; cb 1d
	RR	(HL)		; cb 1e
	RR	A		; cb 1f
	SLA	B		; cb 20
	SLA	C		; cb 21
	SLA	D		; cb 22
	SLA	E		; cb 23
	SLA	H		; cb 24
	SLA	L		; cb 25
	SLA	(HL)		; cb 26
	SLA	A		; cb 27
	SRA	B		; cb 28
	SRA	C		; cb 29
	SRA	D		; cb 2a
	SRA	E		; cb 2b
	SRA	H		; cb 2c
	SRA	L		; cb 2d
	SRA	(HL)		; cb 2e
	SRA	A		; cb 2f ;codes cb 30 - cb 37 are invalid
	SRL	B		; cb 38
	SRL	C		; cb 39
	SRL	D		; cb 3a
	SRL	E		; cb 3b
	SRL	H		; cb 3c
	SRL	L		; cb 3d
	SRL	(HL)		; cb 3e
	SRL	A		; cb 3f
	BIT	0,B		; cb 40
	BIT	0,C		; cb 41
	BIT	0,D		; cb 42
	BIT	0,E		; cb 43
	BIT	0,H		; cb 44
	BIT	0,L		; cb 45
	BIT	0,(HL)		; cb 46
	BIT	0,A		; cb 47
	BIT	1,B		; cb 48
	BIT	1,C		; cb 49
	BIT	1,D		; cb 4a
	BIT	1,E		; cb 4b
	BIT	1,H		; cb 4c
	BIT	1,L		; cb 4d
	BIT	1,(HL)		; cb 4e
	BIT	1,A		; cb 4f
	BIT	2,B		; cb 50
	BIT	2,C		; cb 51
	BIT	2,D		; cb 52
	BIT	2,E		; cb 53
	BIT	2,H		; cb 54
	BIT	2,L		; cb 55
	BIT	2,(HL)		; cb 56
	BIT	2,A		; cb 57
	BIT	3,B		; cb 58
	BIT	3,C		; cb 59
	BIT	3,D		; cb 5a
	BIT	3,E		; cb 5b
	BIT	3,H		; cb 5c
	BIT	3,L		; cb 5d
	BIT	3,(HL)		; cb 5e
	BIT	3,A		; cb 5f
	BIT	4,B		; cb 60
	BIT	4,C		; cb 61
	BIT	4,D		; cb 62
	BIT	4,E		; cb 63
	BIT	4,H		; cb 64
	BIT	4,L		; cb 65
	BIT	4,(HL)		; cb 66
	BIT	4,A		; cb 67
	BIT	5,B		; cb 68
	BIT	5,C		; cb 69
	BIT	5,D		; cb 6a
	BIT	5,E		; cb 6b
	BIT	5,H		; cb 6c
	BIT	5,L		; cb 6d
	BIT	5,(HL)		; cb 6e
	BIT	5,A		; cb 6f
	BIT	6,B		; cb 70
	BIT	6,C		; cb 71
	BIT	6,D		; cb 72
	BIT	6,E		; cb 73
	BIT	6,H		; cb 74
	BIT	6,L		; cb 75
	BIT	6,(HL)		; cb 76
	BIT	6,A		; cb 77
	BIT	7,B		; cb 78
	BIT	7,C		; cb 79
	BIT	7,D		; cb 7a
	BIT	7,E		; cb 7b
	BIT	7,H		; cb 7c
	BIT	7,L		; cb 7d
	BIT	7,(HL)		; cb 7e
	BIT	7,A		; cb 7f
	RES	0,B		; cb 80
	RES	0,C		; cb 81
	RES	0,D		; cb 82
	RES	0,E		; cb 83
	RES	0,H		; cb 84
	RES	0,L		; cb 85
	RES	0,(HL)		; cb 86
	RES	0,A		; cb 87
	RES	1,B		; cb 88
	RES	1,C		; cb 89
	RES	1,D		; cb 8a
	RES	1,E		; cb 8b
	RES	1,H		; cb 8c
	RES	1,L		; cb 8d
	RES	1,(HL)		; cb 8e
	RES	1,A		; cb 8f
	RES	2,B		; cb 90
	RES	2,C		; cb 91
	RES	2,D		; cb 92
	RES	2,E		; cb 93
	RES	2,H		; cb 94
	RES	2,L		; cb 95
	RES	2,(HL)		; cb 96
	RES	2,A		; cb 97
	RES	3,B		; cb 98
	RES	3,C		; cb 99
	RES	3,D		; cb 9a
	RES	3,E		; cb 9b
	RES	3,H		; cb 9c
	RES	3,L		; cb 9d
	RES	3,(HL)		; cb 9e
	RES	3,A		; cb 9f
	RES	4,B		; cb a0
	RES	4,C		; cb a1
	RES	4,D		; cb a2
	RES	4,E		; cb a3
	RES	4,H		; cb a4
	RES	4,L		; cb a5
	RES	4,(HL)		; cb a6
	RES	4,A		; cb a7
	RES	5,B		; cb a8
	RES	5,C		; cb a9
	RES	5,D		; cb aa
	RES	5,E		; cb ab
	RES	5,H		; cb ac
	RES	5,L		; cb ad
	RES	5,(HL)		; cb ae
	RES	5,A		; cb af
	RES	6,B		; cb b0
	RES	6,C		; cb b1
	RES	6,D		; cb b2
	RES	6,E		; cb b3
	RES	6,H		; cb b4
	RES	6,L		; cb b5
	RES	6,(HL)		; cb b6
	RES	6,A		; cb b7
	RES	7,B		; cb b8
	RES	7,C		; cb b9
	RES	7,D		; cb ba
	RES	7,E		; cb bb
	RES	7,H		; cb bc
	RES	7,L		; cb bd
	RES	7,(HL)		; cb be
	RES	7,A		; cb bf
	SET	0,B		; cb c0
	SET	0,C		; cb c1
	SET	0,D		; cb c2
	SET	0,E		; cb c3
	SET	0,H		; cb c4
	SET	0,L		; cb c5
	SET	0,(HL)		; cb c6
	SET	0,A		; cb c7
	SET	1,B		; cb c8
	SET	1,C		; cb c9
	SET	1,D		; cb ca
	SET	1,E		; cb cb
	SET	1,H		; cb cc
	SET	1,L		; cb cd
	SET	1,(HL)		; cb ce
	SET	1,A		; cb cf
	SET	2,B		; cb d0
	SET	2,C		; cb d1
	SET	2,D		; cb d2
	SET	2,E		; cb d3
	SET	2,H		; cb d4
	SET	2,L		; cb d5
	SET	2,(HL)		; cb d6
	SET	2,A		; cb d7
	SET	3,B		; cb d8
	SET	3,C		; cb d9
	SET	3,D		; cb da
	SET	3,E		; cb db
	SET	3,H		; cb dc
	SET	3,L		; cb dd
	SET	3,(HL)		; cb de
	SET	3,A		; cb df
	SET	4,B		; cb e0
	SET	4,C		; cb e1
	SET	4,D		; cb e2
	SET	4,E		; cb e3
	SET	4,H		; cb e4
	SET	4,L		; cb e5
	SET	4,(HL)		; cb e6
	SET	4,A		; cb e7
	SET	5,B		; cb e8
	SET	5,C		; cb e9
	SET	5,D		; cb ea
	SET	5,E		; cb eb
	SET	5,H		; cb ec
	SET	5,L		; cb ed
	SET	5,(HL)		; cb ee
	SET	5,A		; cb ef
	SET	6,B		; cb f0
	SET	6,C		; cb f1
	SET	6,D		; cb f2
	SET	6,E		; cb f3
	SET	6,H		; cb f4
	SET	6,L		; cb f5
	SET	6,(HL)		; cb f6
	SET	6,A		; cb f7
	SET	7,B		; cb f8
	SET	7,C		; cb f9
	SET	7,D		; cb fa
	SET	7,E		; cb fb
	SET	7,H		; cb fc
	SET	7,L		; cb fd
	SET	7,(HL)		; cb fe
	SET	7,A		; cb ff
	IN	B,(C)		; ed 40 ;  ed extended codes
	OUT	(C),B		; ed 41
	SBC	HL,BC		; ed 42
	LD	(NN),BC		; ed 43
	NEG			; ed 44
	RETN			; ed 45
;
	IM	0		; ed 46
	LD	I,A		; ed 47
	IN	C,(C)		; ed 48
	OUT	(C),C		; ed 49
	ADC	HL,BC		; ed 4a
	LD	BC,(NN)		; ed 4b
	RETI			; ed 4d
;
	LD	R,A		; ed 4f
	IN	D,(C)		; ed 50
	OUT	(C),D		; ed 51
	SBC	HL,DE		; ed 52
	LD	(NN),DE		; ed 53
	IM	1		; ed 56
	LD	A,I		; ed 57
	IN	E,(C)		; ed 58
	OUT	(C),E		; ed 59
	ADC	HL,DE		; ed 5a
	LD	DE,(NN)		; ed 5b
	IM	2		; ed 5e
	LD	A,R		; ed 5f
	IN	H,(C)		; ed 60
	OUT	(C),H		; ed 61
	SBC	HL,HL		; ed 62
	RRD			; ed 67
	IN	L,(C)		; ed 68
	OUT	(C),L		; ed 69
	ADC	HL,HL		; ed 6a
	RLD			; ed 6f
	SBC	HL,SP		; ed 72
	LD	(NN),SP		; ed 73
	IN	A,(C)		; ed 78
	OUT	(C),A		; ed 79
	ADC	HL,SP		; ed 7a
	LD 	SP,(NN)		; ed 7b
	LDI			; ed a0
	CPI			; ed a1
	INI			; ed a2
	OUTI			; ed a3
	LDD			; ed a8
	CPD			; ed a9
	IND			; ed aa
	OUTD			; ed ab
	LDIR			; ed b0
	CPIR			; ed b1
	INIR			; ed b2
	OTIR			; ed b3
	LDDR			; ed b8
	CPDR			; ed b9
	INDR			; ed ba
	OTDR			; ed bb
	ADD	IX,BC		; dd 09 ;  indexed codes
	ADD	IX,DE		; dd 19
	LD	IX,NN		; dd 21
	LD	(NN),IX		; dd 22
	INC	IX		; dd 23
	ADD	IX,IX		; dd 29
	LD	IX,(NN)		; dd 2a
	DEC	IX		; dd 2b
	INC	(IX+N)		; dd 34
	DEC	(IX+N)		; dd 35
	LD	(IX+N),12H	; dd 36
	ADD	IX,SP		; dd 39
	LD	B,(IX+N)	; dd 46
	LD	C,(IX+N)	; dd 4e
	LD	D,(IX+N)	; dd 56
	LD	E,(IX+N)	; dd 5e
	LD	H,(IX+N)	; dd 66
	LD	L,(IX+N)	; dd 6e
	LD	(IX+N),B	; dd 70
	LD	(IX+N),C	; dd 71
	LD	(IX+N),D	; dd 72
	LD	(IX+N),E	; dd 73
	LD	(IX+N),H	; dd 74
	LD	(IX+N),L	; dd 75
	LD	(IX+N),A	; dd 77
	LD	A,(IX+N)	; dd 7e
	ADD	A,(IX+N)	; dd 86
	ADC	A,(IX+N)	; dd 8e
	SUB	(IX+N)		; dd 96
	SBC	A,(IX+N)	; dd 9e
	AND	(IX+N)		; dd a6
	XOR	(IX+N)		; dd ae
	OR	(IX+N)		; dd b6
	CP	(IX+N)		; dd be
	POP	IX		; dd e1
	EX	(SP),IX		; dd e3
	PUSH	IX		; dd e5
	JP	(IX)		; dd e9
;
	LD	SP,IX		; dd f9
	RLC	(IX+N)		; dd cb nn 06
	RRC	(IX+N)		; dd cb nn 0e
	RL	(IX+N)		; dd cb nn 16
	RR	(IX+N)		; dd cb nn 1e
	SLA	(IX+N)		; dd cb nn 26
	SRA	(IX+N)		; dd cb nn 2e
	SRL	(IX+N)		; dd cb nn 3e
	BIT	0,(IX+N)	; dd cb nn 46
	BIT	1,(IX+N)	; dd cb nn 4e
	BIT	2,(IX+N)	; dd cb nn 56
	BIT	3,(IX+N)	; dd cb nn 5e
	BIT	4,(IX+N)	; dd cb nn 66
	BIT	5,(IX+N)	; dd cb nn 6e
	BIT	6,(IX+N)	; dd cb nn 76
	BIT	7,(IX+N)	; dd cb nn 7e
	RES	0,(IX+N)	; dd cb nn 86
	RES	1,(IX+N)	; dd cb nn 8e
	RES	2,(IX+N)	; dd cb nn 96
	RES	3,(IX+N)	; dd cb nn 9e
	RES	4,(IX+N)	; dd cb nn a6
	RES	5,(IX+N)	; dd cb nn ae
	RES	6,(IX+N)	; dd cb nn b6
	RES	7,(IX+N)	; dd cb nn be
	SET	0,(IX+N)	; dd cb nn c6
	SET	1,(IX+N)	; dd cb nn ce
	SET	2,(IX+N)	; dd cb nn d6
	SET	3,(IX+N)	; dd cb nn de
	SET	4,(IX+N)	; dd cb nn e6
	SET	5,(IX+N)	; dd cb nn ee
	SET	6,(IX+N)	; dd cb nn f6
	SET	7,(IX+N)	; dd cb nn fe
	ADD	IY,BC		; fd 09
	ADD	IY,DE		; fd 19
	LD	IY,NN		; fd 21
	LD	(NN),IY		; fd 22
	INC	IY		; fd 23
	ADD	IY,IY		; fd 29
	LD	IY,(NN)		; fd 2a
	DEC	IY		; fd 2b
	INC	(IY+N)		; fd 34
	DEC	(IY+N)		; fd 35
	LD	(IY+N),34H	; fd 36
	ADD	IY,SP		; fd 39
	LD	B,(IY+N)	; fd 46
	LD	C,(IY+N)	; fd 4e
	LD	D,(IY+N)	; fd 56
	LD	E,(IY+N)	; fd 5e
	LD	H,(IY+N)	; fd 66
	LD	L,(IY+N)	; fd 6e
	LD	(IY+N),B	; fd 70
	LD	(IY+N),C	; fd 71
	LD	(IY+N),D	; fd 72
	LD	(IY+N),E	; fd 73
	LD	(IY+N),H	; fd 74
	LD	(IY+N),L	; fd 75
	LD	(IY+N),A	; fd 77
	LD	A,(IY+N)	; fd 7e
	ADD	A,(IY+N)	; fd 86
	ADC	A,(IY+N)	; fd 8e
	SUB	(IY+N)		; fd 96
	SBC	A,(IY+N)	; fd 9e
	AND	(IY+N)		; fd a6
	XOR	(IY+N)		; fd ae
	OR	(IY+N)		; fd b6
	CP	(IY+N)		; fd be
	POP	IY		; fd e1
	EX	(SP),IY		; fd e3
	PUSH	IY		; fd e5
	JP	(IY)		; fd e9
;
	LD	SP,IY		; fd f9
	RLC	(IY+N)		; fd cb nn 06
	RRC	(IY+N)		; fd cb nn 0e
	RL	(IY+N)		; fd cb nn 16
	RR	(IY+N)		; fd cb nn 1e
	SLA	(IY+N)		; fd cb nn 26
	SRA	(IY+N)		; fd cb nn 2e
	SRL	(IY+N)		; fd cb nn 3e
	BIT	0,(IY+N)	; fd cb nn 46
	BIT	1,(IY+N)	; fd cb nn 4e
	BIT	2,(IY+N)	; fd cb nn 56
	BIT	3,(IY+N)	; fd cb nn 5e
	BIT	4,(IY+N)	; fd cb nn 66
	BIT	5,(IY+N)	; fd cb nn 6e
	BIT	6,(IY+N)	; fd cb nn 76
	BIT	7,(IY+N)	; fd cb nn 7e
	RES	0,(IY+N)	; fd cb nn 86
	RES	1,(IY+N)	; fd cb nn 8e
	RES	2,(IY+N)	; fd cb nn 96
	RES	3,(IY+N)	; fd cb nn 9e
	RES	4,(IY+N)	; fd cb nn a6
	RES	5,(IY+N)	; fd cb nn ae
	RES	6,(IY+N)	; fd cb nn b6
	RES	7,(IY+N)	; fd cb nn be
	SET	0,(IY+N)	; fd cb nn c6
	SET	1,(IY+N)	; fd cb nn ce
	SET	2,(IY+N)	; fd cb nn d6
	SET	3,(IY+N)	; fd cb nn de
	SET	4,(IY+N)	; fd cb nn e6
	SET	5,(IY+N)	; fd cb nn ee
	SET	6,(IY+N)	; fd cb nn f6
	SET	7,(IY+N)	; fd cb nn fe
;
	END
;

